/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledVacuumModule
extends CompiledModule {
    public static final String NBT_XP_FLUID_TYPE = "XPFluidType";
    public static final String NBT_AUTO_EJECT = "AutoEject";
    private final boolean fastPickup = this.getAugmentCount((Item)ModItems.FAST_PICKUP_AUGMENT.get()) > 0;
    private final boolean xpMode = this.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0;
    private final boolean autoEjecting;
    private final FluidStack xpJuiceStack;
    private BlockEntity fluidReceiver = null;
    private Direction fluidReceiverFace = null;
    private int xpBuffered = 0;
    private final XPCollection.XPCollectionType xpCollectionType;

    public CompiledVacuumModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = stack.m_41737_("modularrouters");
        if (compound != null) {
            this.xpCollectionType = XPCollection.getXPType(compound.m_128451_(NBT_XP_FLUID_TYPE));
            this.autoEjecting = compound.m_128471_(NBT_AUTO_EJECT);
            if (this.xpMode) {
                Fluid xpFluid = this.xpCollectionType.getFluid();
                FluidStack fluidStack = this.xpJuiceStack = xpFluid == Fluids.f_76191_ ? FluidStack.EMPTY : new FluidStack(xpFluid, 1000);
                if (router != null) {
                    this.findFluidReceiver(router);
                }
            } else {
                this.xpJuiceStack = FluidStack.EMPTY;
            }
        } else {
            this.xpCollectionType = XPCollection.XPCollectionType.BOTTLE_O_ENCHANTING;
            this.autoEjecting = false;
            this.xpJuiceStack = FluidStack.EMPTY;
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        if (this.xpMode) {
            return this.handleXpMode(router);
        }
        return this.handleItemMode(router);
    }

    @Override
    public void onNeighbourChange(ModularRouterBlockEntity router) {
        this.findFluidReceiver(router);
    }

    private void findFluidReceiver(ModularRouterBlockEntity router) {
        if (!this.xpMode || this.xpJuiceStack.isEmpty()) {
            return;
        }
        this.fluidReceiver = null;
        for (Direction face : MiscUtil.DIRECTIONS) {
            BlockEntity te = router.nonNullLevel().m_7702_(router.m_58899_().m_142300_(face));
            if (te != null) {
                te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.m_122424_()).ifPresent(handler -> {
                    if (handler.fill(this.xpJuiceStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        this.fluidReceiver = te;
                        this.fluidReceiverFace = face.m_122424_();
                    }
                });
            }
            if (this.fluidReceiver != null) break;
        }
    }

    private boolean handleItemMode(ModularRouterBlockEntity router) {
        if (router.isBufferFull()) {
            return false;
        }
        ItemStack bufferStack = router.getBuffer().getStackInSlot(0);
        BlockPos centrePos = this.getTarget().gPos.m_122646_();
        int range = this.getRange();
        List items = router.nonNullLevel().m_45976_(ItemEntity.class, new AABB(centrePos.m_142082_(-range, -range, -range), centrePos.m_142082_(range + 1, range + 1, range + 1)));
        int toPickUp = this.getItemsPerTick(router);
        for (ItemEntity item : items) {
            if (!item.m_6084_() || !this.fastPickup && item.m_32063_()) continue;
            ItemStack stackOnGround = item.m_32055_();
            if (!bufferStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stackOnGround, (ItemStack)bufferStack) || !this.getFilter().test(stackOnGround)) continue;
            int inRouter = bufferStack.m_41613_();
            int spaceInRouter = this.getRegulationAmount() > 0 ? Math.min(stackOnGround.m_41741_(), this.getRegulationAmount()) - inRouter : stackOnGround.m_41741_() - inRouter;
            ItemStack vacuumed = stackOnGround.m_41620_(Math.min(this.getItemsPerTick(router), spaceInRouter));
            ItemStack excess = router.insertBuffer(vacuumed);
            int remaining = excess == null ? 0 : excess.m_41613_();
            stackOnGround.m_41769_(remaining);
            int inserted = vacuumed.m_41613_() - remaining;
            toPickUp -= inserted;
            if (stackOnGround.m_41619_()) {
                item.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (inserted > 0 && ((Boolean)ConfigHolder.common.module.vacuumParticles.get()).booleanValue() && router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2) {
                ((ServerLevel)router.nonNullLevel()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, item.m_20185_(), item.m_20186_() + 0.25, item.m_20189_(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            if (toPickUp > 0) continue;
            break;
        }
        return toPickUp < this.getItemsPerTick(router);
    }

    private boolean handleXpMode(ModularRouterBlockEntity router) {
        ExperienceOrb orb;
        int spaceForXp;
        BlockPos centrePos = this.getTarget().gPos.m_122646_();
        int range = this.getRange();
        List orbs = router.nonNullLevel().m_45976_(ExperienceOrb.class, new AABB(centrePos).m_82400_((double)range));
        if (orbs.isEmpty()) {
            return false;
        }
        ItemStack inRouterStack = router.getBufferItemStack();
        LazyOptional lazyFluidHandler = LazyOptional.empty();
        if (this.xpCollectionType.isSolid()) {
            if (!inRouterStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inRouterStack, (ItemStack)this.xpCollectionType.getIcon())) {
                return false;
            }
            spaceForXp = (inRouterStack.m_41741_() - inRouterStack.m_41613_()) * this.xpCollectionType.getXpRatio();
        } else {
            if (this.fluidReceiver != null && this.fluidReceiver.m_58901_()) {
                this.findFluidReceiver(router);
            }
            lazyFluidHandler = this.fluidReceiver != null ? this.fluidReceiver.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidReceiverFace) : router.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            spaceForXp = lazyFluidHandler.map(this::findSpaceForXPFluid).orElse(0);
        }
        if (spaceForXp == 0) {
            return false;
        }
        int initialSpaceForXp = spaceForXp;
        Iterator iterator = orbs.iterator();
        while (iterator.hasNext() && (orb = (ExperienceOrb)iterator.next()).m_20801_() <= spaceForXp) {
            if (this.xpCollectionType.isSolid()) {
                this.xpBuffered += orb.m_20801_();
                if (this.xpBuffered > this.xpCollectionType.getXpRatio()) {
                    int count = this.xpBuffered / this.xpCollectionType.getXpRatio();
                    ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.xpCollectionType.getIcon(), (int)count);
                    ItemStack excess = router.insertBuffer(stack);
                    this.xpBuffered -= stack.m_41613_() * this.xpCollectionType.getXpRatio();
                    if (!excess.m_41619_()) {
                        InventoryUtils.dropItems(router.nonNullLevel(), Vec3.m_82512_((Vec3i)router.m_58899_()), excess);
                    }
                }
            } else {
                boolean filledAll = lazyFluidHandler.map(xpHandler -> this.doFluidXPFill(orb, (IFluidHandler)xpHandler)).orElse(false);
                if (!filledAll) {
                    spaceForXp = 0;
                }
            }
            spaceForXp -= orb.m_20801_();
            orb.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return initialSpaceForXp - spaceForXp > 0;
    }

    private boolean doFluidXPFill(ExperienceOrb orb, IFluidHandler xpHandler) {
        FluidStack xpStack = new FluidStack(this.xpJuiceStack.getFluid(), orb.m_20801_() * this.xpCollectionType.getXpRatio() + this.xpBuffered);
        int filled = xpHandler.fill(xpStack, IFluidHandler.FluidAction.EXECUTE);
        if (filled < xpStack.getAmount()) {
            this.xpBuffered = xpStack.getAmount() - filled;
            return false;
        }
        this.xpBuffered = 0;
        return true;
    }

    private int findSpaceForXPFluid(IFluidHandler xpHandler) {
        int space = 0;
        for (int idx = 0; idx < xpHandler.getTanks(); ++idx) {
            FluidStack fluidStack;
            if (!xpHandler.isFluidValid(idx, this.xpJuiceStack) || !(fluidStack = xpHandler.getFluidInTank(idx)).isEmpty() && fluidStack.getFluid() != this.xpCollectionType.getFluid()) continue;
            space += (xpHandler.getTankCapacity(idx) - fluidStack.getAmount()) / this.xpCollectionType.getXpRatio();
        }
        return space;
    }

    @Override
    public List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        if (router == null) {
            return null;
        }
        ModuleItem.RelativeDirection dir = this.getDirection();
        int offset = dir == ModuleItem.RelativeDirection.NONE ? 0 : this.getRange() + 1;
        Direction facing = router.getAbsoluteFacing(dir);
        GlobalPos gPos = MiscUtil.makeGlobalPos(router.nonNullLevel(), router.m_58899_().m_5484_(facing, offset));
        return Collections.singletonList(new ModuleTarget(gPos, facing));
    }

    public XPCollection.XPCollectionType getXPCollectionType() {
        return this.xpCollectionType;
    }

    public boolean isAutoEjecting() {
        return this.autoEjecting;
    }

    public boolean isXpMode() {
        return this.xpMode;
    }
}

